# Localization [![Packagist License][badge_license]](LICENSE.md) [![For Laravel][badge_laravel]][link-github-repo]

[![Github Workflow Status][badge_build]][link-github-status]
[![Coverage Status][badge_coverage]][link-scrutinizer]
[![Scrutinizer Code Quality][badge_quality]][link-scrutinizer]
[![SensioLabs Insight][badge_insight]][link-insight]
[![Github Issues][badge_issues]][link-github-issues]

[![Packagist][badge_package]][link-packagist]
[![Packagist Release][badge_release]][link-packagist]
[![Packagist Downloads][badge_downloads]][link-packagist]

*By [ARCANEDEV&copy;](http://www.arcanedev.net/)*

Easy i18n localization for Laravel, an useful tool to combine with Laravel localization classes.

Official documentation for Localization package can be found at the [Docs folder](_docs).

Feel free to check out the [releases](https://github.com/ARCANEDEV/Localization/releases), [license](LICENSE.md), and [contribution guidelines](CONTRIBUTING.md).

### Features

  * Easy setup & configuration.
  * Laravel `5.x` to `8.x` are supported.
  * SEO-Friendly (Search engine optimization).
  * New extended Router to manage your localized routes.
  * Translated Eloquent Models.
  * Locales selector menu (Publishable & Customizable).
  * Locales manager: List all locales / supported locales, change default locale / supported locales on the fly, and more.
  * Made with :heart: &amp; :coffee:.

## Table of contents

  1. [Installation and Setup](_docs/1-Installation-and-Setup.md)
  2. [Configuration](_docs/2-Configuration.md)
  3. [Usage](_docs/3-Usage.md)
  4. [FAQ](_docs/4-FAQ.md)

## Contribution

Any ideas are welcome. Feel free to submit any issues or pull requests, please check the [contribution guidelines](CONTRIBUTING.md).

## Security

If you discover any security related issues, please email arcanedev.maroc@gmail.com instead of using the issue tracker.

## Credits

- The Localization package was inspired from [mcamara/laravel-localization](https://github.com/mcamara/laravel-localization).
- The Translated Models was inspired from [spatie/laravel-translatable](https://github.com/spatie/laravel-translatable).
- [ARCANEDEV][link-author]
- [All Contributors][link-contributors]

[badge_license]:   http://img.shields.io/packagist/l/arcanedev/localization.svg?style=flat-square
[badge_laravel]:   https://img.shields.io/badge/Laravel-5.x%20to%208.x-orange.svg?style=flat-square
[badge_build]:     https://img.shields.io/github/workflow/status/ARCANEDEV/Localization/run-tests?style=flat-square
[badge_coverage]:  https://img.shields.io/scrutinizer/coverage/g/ARCANEDEV/Localization.svg?style=flat-square
[badge_quality]:   https://img.shields.io/scrutinizer/g/ARCANEDEV/Localization.svg?style=flat-square
[badge_insight]:   https://img.shields.io/sensiolabs/i/30a231b2-295e-466a-8733-fe95cf2bc48d.svg?style=flat-square
[badge_issues]:    http://img.shields.io/github/issues/ARCANEDEV/Localization.svg?style=flat-square
[badge_package]:   https://img.shields.io/badge/package-arcanedev/localization-blue.svg?style=flat-square
[badge_release]:   https://img.shields.io/packagist/v/arcanedev/localization.svg?style=flat-square
[badge_downloads]: https://img.shields.io/packagist/dt/arcanedev/localization.svg?style=flat-square

[link-author]:        https://github.com/arcanedev-maroc
[link-github-repo]:   https://github.com/ARCANEDEV/Localization
[link-github-status]: https://github.com/ARCANEDEV/localization/actions
[link-github-issues]: https://github.com/ARCANEDEV/Localization/issues
[link-contributors]:  https://github.com/ARCANEDEV/Localization/graphs/contributors
[link-packagist]:     https://packagist.org/packages/arcanedev/localization
[link-scrutinizer]:   https://scrutinizer-ci.com/g/ARCANEDEV/Localization/?branch=master
[link-insight]:       https://insight.sensiolabs.com/projects/30a231b2-295e-466a-8733-fe95cf2bc48d
